from PyQt5.QtWidgets import *
from window import *
from threadMcu import *
from threadSourceMeter import *
import os

class Ui_CusMainWindow(Ui_mainWindow):
    def __init__(self, MainWindow):
        self.setupUi(MainWindow)
        self.displayInit()
        #Add a thread in Window and link the signals to the window display
        self.thread_McuComToolHandle = Thread_McuComToolHandle()
        self.thread_McuComToolHandle.signalComData.connect(self.mcu_DataDisplay)  #Link Data to display
        self.thread_McuComToolHandle.signalComPort.connect(self.mcu_PortDispaly)
        self.thread_McuComToolHandle.signalComLog.connect(self.mcu_LogDispaly)
        self.thread_McuComToolHandle.start()

        self.thread_SmComToolHandle = Thread_SmComToolHandle()
        self.thread_SmComToolHandle.signalComLog.connect(self.sm_LogDispaly)
        self.thread_SmComToolHandle.signalComPort.connect(self.sm_PortDispaly)
        self.thread_SmComToolHandle.signalComData.connect(self.sm_DataDisplay)
        self.thread_SmComToolHandle.signalTestDone.connect(self.thread_McuComToolHandle.closeComPort)#Colse the COM port when the SM patch finish running
        self.thread_SmComToolHandle.start()

    ###############################################Communication page setting################################################
    def displayInit(self):
        #update MCU COM Tool display
        self.comboBox_McuBaudRate.clear()  # init COM box
        self.comboBox_McuPortSelection.clear()
        self.comboBox_McuBaudRate.addItems(["115200"])
        #connect PortOpen button to port open function
        self.pushButton_McuUartOpen.clicked.connect(self.mcu_ComPortOpen) #Connect openPort function to connect button
        self.pushButton_McuUartClose.clicked.connect(self.mcu_ComPortClose)  # Connect openPort function to connect button
        self.pushButton_McuFileLoad.clicked.connect(self.mcu_FileLoad)  # Connect openPort function to connect button
        self.pushButton_McuStartTx.clicked.connect(self.mcu_StartTransmitMcuData)
        self.pushButton_SmParamFileLoad.clicked.connect(self.sm_ParamFileLoad)
        self.pushButton_SmRunFileload.clicked.connect(self.sm_RunFileLoad)
        self.pushButton_SmParamFileConverson.clicked.connect(self.sm_ParamFileConversion)
        self.pushButton_SmRunFileConverson.clicked.connect(self.sm_RunFileConversion)

        #update Source Meter COM Tool display
        self.comboBox_McuPortSelection.clear()
        self.pushButton_SmUartOpen.clicked.connect(self.sm_ComPortOpen)  # Connect openPort function to connect button
        self.pushButton_SmStartTest.clicked.connect(self.sm_StartTest)
        self.pushButton_SmEndTest.clicked.connect(self.sm_EndTest)

    def closeEvent(self):
        self.thread_SmComToolHandle.endTest()
        self.thread_SmComToolHandle.excelSave()
        self.thread_McuComToolHandle.closeComPort()

    def sm_LogDispaly(self,str):
        outputStr = str.strip()
        self.textBrowser_SmStatus.append(outputStr)

    def mcu_LogDispaly(self,str):
        self.lineEdit_McuStatus.setText(str)

    def sm_ComPortOpen(self):
        self.sm_DataDisplay([])  # Clear the display
        item = self.comboBox_SmPortSelection.currentText()# find current selected COM
        if(item != ""):
            self.thread_SmComToolHandle.openComPort(item)
        else:
            self.textBrowser_SmStatus.append("Port open failed!")

    def mcu_ComPortOpen(self):
        self.mcu_DataDisplay([])#Clear the display
        item = self.comboBox_McuPortSelection.currentText()        # find current selected COM
        if(item != ""):
            self.thread_McuComToolHandle.openComPort(item)
        else:
            self.lineEdit_McuStatus.setText("Port open failed!")

            
    def mcu_ComPortClose(self):
        # find current selected COM
        item = self.comboBox_McuPortSelection.currentText()
        if(item != ""):
            self.thread_McuComToolHandle.closeComPort()
        else:
            self.lineEdit_McuStatus.setText("No port is available!")

    def sm_PortDispaly(self, str):
        if str != "None":
            self.comboBox_SmPortSelection.addItem(str)
        else:
            self.comboBox_SmPortSelection.clear()

    def mcu_PortDispaly(self, str):
        if str != "None":
            self.comboBox_McuPortSelection.addItem(str)
        else:
            self.comboBox_McuPortSelection.clear()

    def sm_StartTest(self):
        testCase = self.comboBox_SmTestcase.currentIndex()
        self.thread_SmComToolHandle.startTest(testCase)

    def sm_EndTest(self):
        self.thread_SmComToolHandle.endTest(1)
        self.thread_McuComToolHandle.closeComPort() #End communication as well

    def mcu_DataDisplay(self,list):
        if len(list) != 0:
            self.lineEdit_McuCounter.setText(str(list[0]))
            self.lineEdit_McuCellVoltage.setText(str(list[1]))
            self.lineEdit_McuCellCurrent.setText(str(list[2]))
            self.lineEdit_McuCellAvgVoltage.setText(str(list[3]))
            self.lineEdit_McuCellAvgCurrent.setText(str(list[4]))
            self.lineEdit_McuTemp.setText(str(list[5]))
            self.lineEdit_McuNomSoc.setText(str(list[6]))
            self.lineEdit_McuCusSoc.setText(str(list[7]))
            self.lineEdit_McuSmoothSoc.setText(str(list[8]))
            self.lineEdit_McuSOH.setText(str(list[9]))
            self.lineEdit_McuNomFullCap.setText(str(list[10]))
            self.lineEdit_McuCusFullCap.setText(str(list[11]))
            self.lineEdit_McuNomRemCap.setText(str(list[12]))
            self.lineEdit_McuCusRemCap.setText(str(list[13]))
            self.lineEdit_McuRawNormFullCap.setText(str(list[14]))
            self.lineEdit_McuCaliOcv.setText(str(list[15]))
            self.lineEdit_McuAbsEmptySOC.setText(str(list[16]))
            self.lineEdit_McuAbsFullSOC.setText(str(list[17]))
            self.lineEdit_McuEmptyMatrixCount.setText(str(list[18]))
            self.lineEdit_McuFullMatrixCount.setText(str(list[19]))
            self.lineEdit_McuDeltaCap.setText(str(list[20]))
            self.lineEdit_McuDeltaSoc.setText(str(list[21]))
            self.lineEdit_McuCaliSOC.setText(str(list[22]))
            self.lineEdit_McuCycles.setText(str(list[23]))
            self.lineEdit_McuFlags.setText(str(list[24]))
            self.lineEdit_McuSystemSate.setText(str(list[25]))
            self.lineEdit_McuBatteryState.setText(str(list[26]))
            self.lineEdit_McuCD1.setText(str(list[27]))
            self.lineEdit_McuCD2.setText(str(list[28]))
            self.lineEdit_McuCD3.setText(str(list[29]))
            self.lineEdit_McuCD4.setText(str(list[30]))
            self.lineEdit_McuCD5.setText(str(list[31]))


        else:
            self.lineEdit_McuCounter.setText('')
            self.lineEdit_McuCellVoltage.setText('')
            self.lineEdit_McuCellCurrent.setText('')
            self.lineEdit_McuCellAvgVoltage.setText('')
            self.lineEdit_McuCellAvgCurrent.setText('')
            self.lineEdit_McuTemp.setText('')
            self.lineEdit_McuNomSoc.setText('')
            self.lineEdit_McuCusSoc.setText('')
            self.lineEdit_McuSmoothSoc.setText('')
            self.lineEdit_McuSOH.setText('')
            self.lineEdit_McuNomFullCap.setText('')
            self.lineEdit_McuCusFullCap.setText('')
            self.lineEdit_McuNomRemCap.setText('')
            self.lineEdit_McuCusRemCap.setText('')
            self.lineEdit_McuRawNormFullCap.setText('')
            self.lineEdit_McuCaliOcv.setText('')
            self.lineEdit_McuAbsEmptySOC.setText('')
            self.lineEdit_McuAbsFullSOC.setText('')
            self.lineEdit_McuEmptyMatrixCount.setText('')
            self.lineEdit_McuFullMatrixCount.setText('')
            self.lineEdit_McuDeltaCap.setText('')
            self.lineEdit_McuDeltaSoc.setText('')
            self.lineEdit_McuCaliSOC.setText('')
            self.lineEdit_McuCycles.setText('')
            self.lineEdit_McuFlags.setText('')
            self.lineEdit_McuSystemSate.setText('')
            self.lineEdit_McuBatteryState.setText('')
            self.lineEdit_McuCD1.setText('')
            self.lineEdit_McuCD2.setText('')
            self.lineEdit_McuCD3.setText('')
            self.lineEdit_McuCD4.setText('')
            self.lineEdit_McuCD5.setText('')

    def sm_DataDisplay(self,list):
        if len(list) != 0:
            self.lineEdit_SmCounter.setText(str(list[0]))
            self.lineEdit_SmCellVoltage.setText(str(list[1]))
            self.lineEdit_SmCellCurrent.setText(str(list[2]))
        else:
            self.lineEdit_SmCounter.setText('')
            self.lineEdit_SmCellVoltage.setText('')
            self.lineEdit_SmCellCurrent.setText('')

    def mcu_FileLoad(self):
        filename, filetype = QFileDialog.getOpenFileNames(None,
                                                          'Select File',
                                                          os.getcwd(), #Get current python file address
                                                          'Excel Files(*.xlsx)')
        if len(filename) == 1:
            self.lineEdit_McuBatRunFile.setText(filename[0])

#Transmit the battery run file to MCU as the voltage/current/temperature input
    def mcu_StartTransmitMcuData(self):
        filename = self.lineEdit_McuBatRunFile.text()
        if ".xlsx" in filename:
            self.thread_McuComToolHandle.startTransmitMcuData(filename)
        else:
            self.lineEdit_McuStatus.setText("Wrong file type!")

    def sm_ParamFileLoad(self):
        filename, filetype = QFileDialog.getOpenFileNames(None,
                                                          'Select File',
                                                          os.getcwd(),  # Get current python file address
                                                          'Excel Files(*.xlsx)')
        if len(filename) == 1:
            self.lineEdit_SmBatParamFile.setText(filename[0])

    def sm_ParamFileConversion(self):
        filename = self.lineEdit_SmBatParamFile.text()
        if ".xlsx" in filename:
            self.thread_SmComToolHandle.paramFileConversion(filename)
        else:
            self.sm_LogDispaly("Wrong file type!")
    def sm_RunFileLoad(self):
        filename, filetype = QFileDialog.getOpenFileNames(None,
                                                          'Select File',
                                                          os.getcwd(),  # Get current python file address
                                                          'Excel Files(*.xlsx)')
        if len(filename) == 1:
            self.lineEdit_SmBatRunFile.setText(filename[0])

    def sm_RunFileConversion(self):
        filename = self.lineEdit_SmBatRunFile.text()
        if ".xlsx" in filename:
            self.thread_SmComToolHandle.runFileConversion(filename)
        else:
            self.sm_LogDispaly("Wrong file type!")

class MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        self.function = None
    def closeEvent(self, event):
        print("Close event")
        self.function() #Save the excel
        event.accept()